<?php

ob_start();
session_start();

include 'db.php';
include '../functions/data.php';
include '../functions/mailer.php';
include '../functions/validate.php';
include '../__autoload/__autoload_controller.php';

$redirect = '../adminsettings.php';

if (isset($_POST['update-setting'])) {

    //Defining Variables
    $site_name = $_POST['site_name'];
    $site_url = $_POST['site_url'];
    $sitemail = $_POST['email'];
    $addr = $_POST['address'];
    $livechat = $_POST['livechat'];
    //$mobile = $_POST['mobile'];
    //$tel = $_POST['tel'];
        
    if(empty($_FILES['logo']['name'])){
        $logo = getData($conn, 1, 'logo', 'general_settings', 'id');

    }
    if(empty($_FILES['fav']['name'])){
        $favicon = getData($conn, 1, 'favicon', 'general_settings', 'id');
        
    }

    //Handling Empty Fields
    $keys = array('Enter Sitename', 'Enter URL', 'Enter Contact Email', 'Enter Site Address');
    $data = array($site_name, $site_url, $sitemail, $addr);
    $empty_data = empty_data($data, $keys);
    if ($empty_data['statue'] == false) {

        $_SESSION['err-msg'] = $empty_data['msg'];
        header('location: ' . $redirect);
        exit();
    }

    if (!filter_var($sitemail, FILTER_VALIDATE_EMAIL)) {//execute error message when user input invalid email

        $_SESSION['err-msg'] = 'Type in a valid email address to continue';
        header('location: ' . $redirect);
        exit();
    }

    $reg = "/^[a-zA-Z ]*$/";
    $name = "/^[a-zA-Z]*$/";
    $reg2 = "/^[a-zA-Z0-9_\/:.]*$/";
    $reg3 = "/^[a-zA-Z0-9_,.?\/)( ]*$/";
    $num = "/^[0-9+]*$/";
    $keys = array('sitename!', 'URL!', 'address');
    $data = array($site_name, $site_url, $addr);
    $regex = array($reg, $reg2, $reg3);
    $empty_data = validate_data($data, $keys, $regex);
    if ($empty_data['statue'] == false) {
        $_SESSION['err-msg'] = $empty_data['msg'];
        header('location: ' . $redirect);
        exit();
    }


    if(!empty($_FILES['logo']['name'])){
        
        $imageName = $_FILES['logo']['name'];
        $imageTmpname = $_FILES['logo']['tmp_name'];
        $imageSize = $_FILES['logo']['size'];
        $imageError = $_FILES['logo']['error'];
        $appendName = 'logo';
        $destination = '/home/contragl/public_html/assets/img/';
        
        $img = uploadImage($imageName, $imageTmpname, $imageSize, $imageError, $appendName, $destination);
        
        if($img['res'] == 0){
            
            $_SESSION['err-msg'] = $img['msg'];
            header('location: ' . $redirect);
            exit();
        }
        
        $logo = $img['msg'];
    }
    
    if(!empty($_FILES['fav']['name'])){
        
        $imageName = $_FILES['fav']['name'];
        $imageTmpname = $_FILES['fav']['tmp_name'];
        $imageSize = $_FILES['fav']['size'];
        $imageError = $_FILES['fav']['error'];
        $appendName = 'apple-icon-57x57';
        $destination = '/home/contragl/public_html/assets/img/favicons/';
        
        $img = uploadImage($imageName, $imageTmpname, $imageSize, $imageError, $appendName, $destination);
        
        if($img['res'] == 0){
            
            $_SESSION['err-msg'] = $img['msg'];
            header('location: ' . $redirect);
            exit();
        }
        
        $favicon = $img['msg'];
    }
    

    //Update User Profile
    $reference = 'id';
    $tableName = 'general_settings';
    //$sym = currencies('../../dist/json/countries/' . strtolower($cur) . '.json');

    $data = array(
        'site_name' => $site_name, 
        'site_url' => $site_url, 
        'address' => $addr,  
        'sitemail' => $sitemail, 
        'liv_chats' => $livechat, 
        'logo' => $logo,
        'favicon' => $favicon
    );
    
    $update = new Controllers\UpdateController($data, $tableName, 1, $reference, $redirect);
    $update->updateData();

    $_SESSION['suc-msg'] = 'General settings updated';
    header('location: '.$redirect);
    exit();

}else{
    header('location: '.$redirect);
    exit();
}