<?php

namespace Controllers;

use Login;
class LoginController extends Login {

    private $username;
    private $password;
    private $redirect;
    private $result;

    public function __construct($username, $password, $redirect){

        $this->username = $username;
        $this->password = $password;
        $this->redirect = $redirect;
    }

    public function loginUser(){
       
        if($this->invalidEmail() == false){

            $_SESSION['res'] = 0;
            $_SESSION['err-msg'] = 'Enter a valid email address';
            // header('location: '.$this->redirect);
            //exit();
        }
        elseif($this->invalidPwd() == false){

            $_SESSION['res'] = 0;
            $_SESSION['err-msg'] = 'Enter a valid password';
            // header('location: '.$this->redirect);
           // exit();
        }else{
            
            $this->getUser($this->username, $this->password, $this->redirect);
        }
    }

    private function invalidEmail(){
        $this->result;
        if(filter_var($this->username, FILTER_VALIDATE_EMAIL)){
            $this->result = true;
        }else {
            $this->result = false;
        }

        return $this->result;
    }

    private function invalidPwd(){
        $this->result;
        if(!preg_match("/^[a-zA-Z0-9@!#?)(&%$+.,\/_ ]*$/", $this->password)){
            $this->result = false;
        }else {
            $this->result = true;
        }

        return $this->result;
    }

}