<?php

namespace Controllers;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

class MailerController {

    private $name;
    private $email;
    private $subject;
    private $message;
    private $sitemail;
    private $sitename;
    private $smtp_host;
    private $smtp_port;
    private $smtp_encrypt;
    private $smtp_user;
    private $smtp_password;
    private $redirect;
    private $result;

    public function __construct($name, $email, $subject, $message, $sitemail, $sitename, $smtp_host, $smtp_port, $smtp_encrypt, $smtp_user, $smtp_password, $redirect){

        $this->name = $name;
        $this->email = $email;
        $this->subject = $subject;
        $this->message = $message;
        $this->sitemail = $sitemail;
        $this->sitename = $sitename;
        $this->smtp_host = $smtp_host;
        $this->smtp_port = $smtp_port;
        $this->smtp_encrypt = $smtp_encrypt;
        $this->smtp_user = $smtp_user;
        $this->smtp_password = $smtp_password;
        $this->redirect = $redirect;
    }

    public function sendMail()
    {
       
        if($this->checkMail() == false){

            $_SESSION['err-msg'] = 'Processing failed, please report this issue';
            $_SESSION['res'] = 0;
            // header('location: '.$this->redirect);
            // exit();
        }
    }

    private function checkMail()
    {
        $this->result;

        require __DIR__.'/PHPMailer/src/Exception.php';
        require __DIR__.'/PHPMailer/src/PHPMailer.php';
        require __DIR__.'/PHPMailer/src/SMTP.php';

        // Create email headers
        // $from = $this->sitename.' <'.$this->sitemail.'>';
        // $headers = "From: $from \r\n";
        // $headers .= "Reply-To: ".$this->sitename." <$from> \r\n";
        // $headers .= "MIME-Version: 1.0\r\n";
        // $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
        // $d= date('M/d/y  h:i:s', time());

        // if(mail($this->email, $this->subject, $this->message, $headers)){
        //     $this->result = true;
        // }else {
        //     $this->result = false;
        // }

        //Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);

try {
    //Server settings
    $mail->SMTPDebug = SMTP::DEBUG_OFF;                      //Enable verbose debug output
    $mail->isSMTP();                                            //Send using SMTP
    $mail->Host       = $this->smtp_host;                     //Set the SMTP server to send through
    $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
    $mail->Username   = $this->smtp_user;                     //SMTP username
    $mail->Password   = $this->smtp_password;           //SMTP Password
    $mail->Port       = $this->smtp_port;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
    // Encryption protocol to use
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;     //Enable implicit TLS encryption
    // Set the encryption system to use - ssl (deprecated) or tls
    $mail->SMTPSecure = $this->smtp_encrypt;

    //Recipients
    $mail->setFrom($this->sitemail, $this->sitename);
    $mail->addAddress($this->email, $this->name);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');


    //Content
    $mail->isHTML(true);        // Set email format to HTML

    if(gettype($this->subject) == 'array'){
        $mail->Subject = $this->subject['subject'];
    }else{
        $mail->Subject = $this->subject;

    }               

    $mail->Body    = $this->message;
    // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

    if(gettype($this->subject) == 'array'){
        // Set language translation header
        if(!empty($this->subject['img-path'])){
            $mail->AddAttachment($this->subject['img-path']);
        }
        if(!empty($this->subject['lang'])){
            $mail->addCustomHeader('Content-Language', $this->subject['lang']); // Replace 'en-US' with your preferred language code
        }
    }

    $mail->send();
    $this->result = true;
} catch (Exception $e) {
    $this->result = false;
}

        return $this->result;
    }

}