<?php

function getData($conn, $id, $data, $tableName, $reference){

    $sql = "SELECT $data FROM $tableName WHERE $reference = ?;";
    $stmt = mysqli_stmt_init($conn);
    if (!mysqli_stmt_prepare($stmt, $sql)) {
     header("location: ./");
    }
    else {
        mysqli_stmt_bind_param($stmt, "s", $id);
        mysqli_stmt_execute($stmt);
 
        $result = mysqli_stmt_get_result($stmt);
        $count = mysqli_num_rows($result);
        if($count<1){
           return false;
        }
        
        $result = mysqli_fetch_array($result);
        return $result[0];
    }
}

function getDataS($conn, $id, $id2, $data, $tableName, $reference, $reference2){

    $sql = "SELECT $data FROM $tableName WHERE $reference=? AND $reference2=?";
    $stmt = mysqli_stmt_init($conn);
    if (!mysqli_stmt_prepare($stmt, $sql)) {
     header("location: ./");
    }
    else {
        mysqli_stmt_bind_param($stmt, "ss", $id, $id2);
        mysqli_stmt_execute($stmt);
 
        $result = mysqli_stmt_get_result($stmt);
        $result = mysqli_fetch_array($result);
        return $result[0];
    }
}

function getWhere($conn, $id, $tableName, $reference){

    $sql = "SELECT * FROM $tableName WHERE $reference = ? ORDER BY id desc";
    $stmt = mysqli_stmt_init($conn);
    if (!mysqli_stmt_prepare($stmt, $sql)) {
     header("location: ./");
    }
    else {
        mysqli_stmt_bind_param($stmt, "s", $id);
        mysqli_stmt_execute($stmt);
 
        $result = mysqli_stmt_get_result($stmt);
        $count = mysqli_num_rows($result);
        if($count<1){
           return false;
    }
        return $result;
    }
}

function getWhereS($conn, $id, $id2, $tableName, $reference, $reference2){

    $sql = "SELECT * FROM $tableName WHERE $reference = '$id' AND $reference2 = '$id2'";
    $result = mysqli_query($conn, $sql);
    if (!$result) {
    return false;
    }
    else {
        $count = mysqli_num_rows($result);
        if($count<1){
           return false;
    }
        return $result;
    }
}

function getWhereLimit($conn, $id, $tableName, $reference, $skip, $fetchnext){

    $sql = "SELECT * FROM $tableName WHERE $reference=? ORDER BY id desc LIMIT $skip,$fetchnext";
    $stmt = mysqli_stmt_init($conn);
    if (!mysqli_stmt_prepare($stmt, $sql)) {
     header("location: ./");
    }
    else {
        mysqli_stmt_bind_param($stmt, "s", $id);
        mysqli_stmt_execute($stmt);
 
        $result = mysqli_stmt_get_result($stmt);
        return $result;
    }
}

function getWhereLimitS($conn, $id, $id2, $tableName, $reference, $reference2, $skip, $fetchnext){

    $sql = "SELECT * FROM $tableName WHERE $reference=? AND $reference2=? ORDER BY id desc LIMIT $skip,$fetchnext";
    $stmt = mysqli_stmt_init($conn);
    if (!mysqli_stmt_prepare($stmt, $sql)) {
     header("location: ./");
    }
    else {
        mysqli_stmt_bind_param($stmt, "ss", $id, $id2);
        mysqli_stmt_execute($stmt);
 
        $result = mysqli_stmt_get_result($stmt);
        return $result;
    }
}

function getAll($conn, $tableName){
    $result = mysqli_query($conn, "SELECT * FROM $tableName ORDER BY id desc");
    if($result){
       return $result;
    }
}

function getAllLimit($conn, $tableName, $skip, $fetchnext){
    $result = mysqli_query($conn, "SELECT * FROM $tableName ORDER BY id desc LIMIT $skip,$fetchnext");
    if($result){
       return $result;
    }
}


function getCount($conn, $id, $tableName, $reference){
    
    $sql = "SELECT * FROM $tableName WHERE $reference=?;";
    $stmt = mysqli_stmt_init($conn);
    if (!mysqli_stmt_prepare($stmt, $sql)) {
     header("location: ./");
    }
    else {
        mysqli_stmt_bind_param($stmt, "s", $id);
        mysqli_stmt_execute($stmt);
 
        $result = mysqli_stmt_get_result($stmt);
        $data = mysqli_num_rows($result);
        return $data;
    }
}

function getAllCount($conn, $tableName){
    
    $sql = "SELECT * FROM $tableName";
    $stmt = mysqli_stmt_init($conn);
    if (!mysqli_stmt_prepare($stmt, $sql)) {
     header("location: ./");
    }
    else {
        mysqli_stmt_execute($stmt);
 
        $result = mysqli_stmt_get_result($stmt);
        $data = mysqli_num_rows($result);
        return $data;
    }
}

function getCountS($conn, $id, $id2, $tableName, $reference, $reference2){
    $sql = "SELECT * FROM $tableName WHERE $reference=? AND $reference2=?";
    $stmt = mysqli_stmt_init($conn);
    if (!mysqli_stmt_prepare($stmt, $sql)) {
     header("location: ./");
    }
    else {
        mysqli_stmt_bind_param($stmt, "ss", $id, $id2);
        mysqli_stmt_execute($stmt);
 
        $result = mysqli_stmt_get_result($stmt);
        $data = mysqli_num_rows($result);
        return $data;
    }
}

function total($conn, $id, $id2, $values, $tableName, $reference, $reference2){

    $sql = "SELECT * FROM $tableName WHERE $reference=? AND $reference2 = ?";
    $stmt = mysqli_stmt_init($conn);
    if (!mysqli_stmt_prepare($stmt, $sql)) {
     header("location: ./");
    }
    else {
        mysqli_stmt_bind_param($stmt, "ss", $id, $id2);
        mysqli_stmt_execute($stmt);
        $data = 0;
        $result = mysqli_stmt_get_result($stmt);
        foreach ($result as $key => $value) {
            $data += $value[$values];
        }
        return $data;
    }
}

function totalLimit($conn, $id, $values, $tableName, $reference, $skip, $fetchnext){

    $sql = "SELECT * FROM $tableName WHERE $reference=? ORDER BY id desc LIMIT $skip,$fetchnext";
    $stmt = mysqli_stmt_init($conn);
    if (!mysqli_stmt_prepare($stmt, $sql)) {
     header("location: ./");
    }
    else {
        mysqli_stmt_bind_param($stmt, "s", $id);
        mysqli_stmt_execute($stmt);
        $data = 0;
        $result = mysqli_stmt_get_result($stmt);
        foreach ($result as $key => $value) {
            $data += $value[$values];
        }
        return number_format($data, '2');
    }
}

function time_since($datetime) {
    $now = new DateTime;
    $ago = new DateTime($datetime);
    $diff = $now->diff($ago);
    
    $diff->w = floor($diff->d / 7);
    $diff->d -= $diff->w * 7;
    
    $string = array(
        'y' => 'year',
        'm' => 'month',
        'w' => 'week',
        'd' => 'day',
        'h' => 'hour',
        'i' => 'minute',
        's' => 'second',
    );
    foreach ($string as $k => &$v) {
        if ($diff->$k) {
            $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
        } else {
            unset($string[$k]);
        }
    }
    
    return $string ? implode(', ', $string) . ' ago' : 'just now';
}

function currency_price($amount, $coinId, $currency){

         // $currencies_total = currencyDetails($coinId, $currency); 
         $url = 'https://min-api.cryptocompare.com/data/price?fsyms='.$coinId.'&tsyms='.$currency;
         $json = json_decode(file_get_contents($url));
         $dollars = $price = 0;
         $price = $json->$currency;
         $convert = $price*$amount;

         return $convert;
}


function crypto_details($symbol){

    // Set the API endpoint and parameters
    $api_endpoint = 'https://min-api.cryptocompare.com/data/pricemultifull';
    $params = 'fsyms=' . $symbol . '&tsyms=USD';

    // Make a request to the CryptoCompare API
    $url = $api_endpoint . '?' . $params;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $output = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($output, true);

    // Extract the market cap and image URL
    $market_cap = $data['RAW'][$symbol]['USD']['MKTCAP'];
    $image_url = 'https://www.cryptocompare.com' . $data['RAW'][$symbol]['USD']['IMAGEURL'];

    $data = [
        'logo_url' => $image_url
    ];
    return $data;
}
function uploadImage($imageName, $imageTmpname, $imageSize, $imageError, $appendName, $destination){

    $imageExt = explode('.', $imageName);
    $imageActualExt = strtolower(end($imageExt));

    $allowed = array('jpg', 'jpeg', 'png', 'gif');

    if (in_array($imageActualExt, $allowed)) {
      if ($imageError === 0) {
        if ($imageSize < 5000000) {//execute if its less than 5mb
          $imageNameNew = $appendName.'.'.$imageActualExt;

           $imageDestination = $destination.''.$imageNameNew;
           move_uploaded_file($imageTmpname, $imageDestination);
 
           $data = [
            'res' => 1,
            'msg' => $imageNameNew
           ];

        return $data;
        } else {
            $data = [
                'res' => 0,
                'msg' => 'File too large minimum of 5mb'
            ];

            return $data;
        }
      } else {
            $data = [
                'res' => 0,
                'msg' => 'Upload Failed! Try again'
            ];

            return $data;
      }
    } else {
            $data = [
                'res' => 0,
                'msg' => 'jpg, png, jpeg file type allowed'
            ];

            return $data;
    }
}

function tokenId($length, $characters) {
     
     $characterslength = strlen($characters);
     $randomString = '';
                    
     for ($i = 0; $i < $length; $i++) {
          $randomString .= $characters[rand(0, $characterslength - 1)];
                           
     }
     return $randomString;
}

function mnemoric_phrase(){
     // Define the BIP39 word list
    $wordList = file('../bip39/bip39-wordlist.txt', FILE_IGNORE_NEW_LINES);

    // Generate a sequence of 12 random numbers
    $sequence = [];
    for ($i = 0; $i < 12; $i++) {
        $sequence[] = random_int(0, 2047);
    }

    // Select words from the list using the sequence of random numbers
    $words = [];
    foreach ($sequence as $index) {
        $words[] = $wordList[$index];
    }

    // Join the words together to create the mnemonic passphrase
    $passphrase = implode(' ', $words);

    return $passphrase;
}

function currencies($url) {

    // read the JSON file content
    $json_string = file_get_contents($url);

    // convert the JSON string to a PHP object
    $data = json_decode($json_string);

    foreach ($data as $item) {
        $sign = $item->units->major->symbol;
        $name = $item->iso->code;
        // do something with the extracted data
    }

    $data = [
        'sign' => $sign,
        'name' => $name
    ];
    return $data;
}

function allcurrencies(){
     // Make a request to the API endpoint to get the latest currency data
     $response = file_get_contents('https://openexchangerates.org/api/currencies.json');
     if ($response) {
         // Convert the JSON response to an associative array
         $currencies = json_decode($response, true);
         return $currencies;
     }
}

function countries($value){

    $timezones = array();

    $countryData = file_get_contents('https://restcountries.com/v2/all');
    $countryList = json_decode($countryData);
    
    if(!empty($value)){
        foreach ($countryList as $country) {
            if($country->name == $value){

                $timezones = DateTimeZone::listIdentifiers(DateTimeZone::PER_COUNTRY, $country->alpha2Code);
                for ($i=0; $i < count($timezones); $i++) { 
                    $timezone = $timezones[$i];
                }

                $data = [
                    'country2Code' => $country->alpha2Code,
                    'country3Code' => $country->alpha3Code,
                    'timezone' => $timezone
                ];

                return $data;
            }
        
        }
    }else{

        $countries = array();
        foreach ($countryList as $country) {
    
            $timezones = DateTimeZone::listIdentifiers(DateTimeZone::PER_COUNTRY, $country->alpha2Code);
            $timezone_list = implode(", ", $timezones);
    
            $a = $country->alpha2Code;
            $b = $country->alpha3Code;
            $c = $country->name;
            $data = [
                'country2Code' => $a,
                'country3Code' => $b,
                'country' => $c,
                'timezone' => $timezone_list
            ];
            $countries[] = $data;
        }
        return $countries;

    }
}