<?php

    //Get user Parent
    function getUserParent($conn, $id) {
        $user = getWhere($conn, $id, 'users', 'user_Id');
        foreach ($user as $user) {
            $parent = getWhere($conn, $user['ref_by'], 'users', 'user_Id');
            if ($parent) {
                foreach ($parent as $parent) {
                    return $parent['name'];
                }
            } else {
                return "null";
            }
        }
    }
  
      //Get user status
      function getUserStatus($conn, $id) {
        $user = getWhere($conn, $id, 'users', 'user_Id');
        foreach ($user as $user) {
            return $user['status'];
        }
      }
  
      //Get User Registration Date
      function getUserRegDate($conn, $id) {
        $user = getWhere($conn, $id, 'users', 'user_Id');
        foreach ($user as $user) {
            return $user['created_at'];
        }
      }
      
      function calculateTotalReferralRewards($conn, $id, $level) {
          
        // referral reward rate
        if($level == 0){
            $reward_percentage = getData($conn, 1, 'referral_commission', 'settings', 'id');
        }elseif($level == 1){
            $reward_percentage = getData($conn, 1, 'referral_commission1', 'settings', 'id');
        }elseif($level == 2){
            $reward_percentage = getData($conn, 1, 'referral_commission2', 'settings', 'id');
        }elseif($level == 3){
            $reward_percentage = getData($conn, 1, 'referral_commission3', 'settings', 'id');
        }elseif($level == 4){
            $reward_percentage = getData($conn, 1, 'referral_commission4', 'settings', 'id');
        }elseif($level == 5){
            $reward_percentage = getData($conn, 1, 'referral_commission5', 'settings', 'id');
        }
        
        $total_rewards = 0;
    
            $deposits = getWhere($conn, $id, 'deposits', 'user');

        // Calculate referral rewards for the specified user's transactions
        foreach ($deposits as $deposit) {
            $reward_amount = $deposit['amount'] * ($reward_percentage/100);
            $total_rewards += $reward_amount;
        }
        
        return $total_rewards;
    
    }

    function getdownlines($conn, $parent, $level = 0, $j = 1) {

    $entry = array();
    $sql = "SELECT * FROM users";
    $result = mysqli_query($conn, $sql);
    $entry = mysqli_fetch_all($result, MYSQLI_ASSOC);

    $referedMembers = [];
    for($i=0; $i<count($entry); $i++){
            if ($entry[$i]['ref_by'] == $parent) {
                
                if($level==0){
                    $levelQuote= "Direct referral";
                }else{
                    $levelQuote= "Indirect referral level $level";
                }

                $referedMember = [
                    'sn' => $j,
                    'name' => $entry[$i]['name'],
                    'email' => $entry[$i]['email'],
                    'level' => $levelQuote,
                    'total_reward' => calculateTotalReferralRewards($conn, $entry[$i]['id'], $level),
                    'parent' => getUserParent($conn, $entry[$i]['user_Id']),
                    'status' => getUserStatus($conn, $entry[$i]['user_Id']),
                    'reg_date' => getUserRegDate($conn, $entry[$i]['user_Id'])
                ];
                array_push($referedMembers, $referedMember);
                $downlines = getdownlines($conn, $entry[$i]['user_Id'], $level+1, $j+1);
                $referedMembers = array_merge($referedMembers, $downlines);
            }

            if($level == 6){
            break;
            }
        }
    
    return $referedMembers;
}

function getArray() {
    $array = [1, 2, 3, 4, 5];
    return $array;
}


